//
//  AppDelegate.swift
//  UtilityMenu Statusbar Example
//
//  Created by Charles Nichols on 2/8/15.
//  http://www.darkartistry.com
//  Copyright (c) 2015 darkartistry. All rights reserved.
//

import Cocoa

/*
Just learning Swift and wanted to share a working example of a simple 
Statusbar app. I've removed the window and set set the LSBackgroundOnly key 
in the app's "Info.plist" file to hide it from the dock:
Application is background = Yes.
*/

let BASEPATH = "/Applications/Utilities"

@NSApplicationMain
class AppDelegate: NSObject, NSApplicationDelegate {

    var statusItem: NSStatusItem? = nil
    
    @IBOutlet weak var statMenu: NSMenu!
    @IBOutlet weak var appMenuItem: NSMenuItem!
    
    func worker(){
        /* Called by the thread to get the application file listing and populate the menu. */

        var counter = 0
        let keys = [NSURLIsDirectoryKey, NSURLLocalizedNameKey]
        
        let fm = NSFileManager.defaultManager()
        let path = NSURL(fileURLWithPath: BASEPATH)
        var enumerator: NSEnumerator = fm.enumeratorAtURL(path!, includingPropertiesForKeys: keys, options: NSDirectoryEnumerationOptions.SkipsSubdirectoryDescendants | NSDirectoryEnumerationOptions.SkipsHiddenFiles | NSDirectoryEnumerationOptions.SkipsPackageDescendants, errorHandler: nil)!
        
        while let element = enumerator.nextObject() as? NSURL {
            
            var path: String! = element.path       // Convert URL to String
            var filename = path.lastPathComponent  // Get the filename only
            
            if filename.hasSuffix("app"){ // return files with this extension
                counter++ // for index
                
                // Add the menu item.
                var appItem: NSMenuItem = statMenu.insertItemWithTitle(filename, action: Selector("appSelected:"), keyEquivalent: "", atIndex: counter)!
                appItem.target = self
                appItem.representedObject = filename
            }
        }
        statusItem?.title=String(counter) // Show count in StatusBar.
    }
    
    @IBAction func appSelected(sender: AnyObject) {
        /* Fired when a menu item is clicked and executes the application. */
        let ws = NSWorkspace.sharedWorkspace()
        
        var selected = sender.representedObject as String
        //println("Selected \(BASEPATH)/\(selected)")
        ws.launchApplication(selected)
        
    }
    
    func applicationDidFinishLaunching(aNotification: NSNotification) {
        /* Start the thread to collect our application list. 
           This could be a timer that periodically checks for
           new items and caches them. I just wanted to see NSThread work.
        */
        let thread = NSThread(target:self, selector:"worker", object:nil)
        thread.start()
    }
    
    func applicationWillTerminate(aNotification: NSNotification) {
        // Insert code here to tear down your application
    }
    
    override func awakeFromNib() {
        /* Build the StatusBar */
        statusItem = NSStatusBar.systemStatusBar().statusItemWithLength(-1)
        self.statusItem!.menu = self.statMenu
        //self.statusItem!.title = "Utilities"
        self.statusItem!.highlightMode = true
        self.statusItem!.image = NSImage(named: "StatusIcons")
    }
    
    @IBAction func quitApp(sender: AnyObject) {
        /* Exit menu item clicked, terminate this app. */
        NSApplication.sharedApplication().terminate(self)
    }

}

