#! /usr/bin/python

'''
 Author: C. Nichols <mohawke@gmail.com>
 Site: http://www.darkartistry.com

 Reference:
    http://www.calendar-365.com/moon/current-moon-phase.html
    http://lunaf.com/english/moon-phases/
'''

import datetime
from math import fmod
import shutil
import os

# ====================================================================

def get_moon_phase(path):

    now = datetime.date.today() #- datetime.timedelta(-3)
    
    new_moon = datetime.date(2012,1,23)
    cycle = 29.530588853   
    phase_length = cycle/8 

    diff = (now - new_moon).days
    ldays = fmod(diff + phase_length/3, cycle)
    current_phase = ldays * ( 8 / cycle )

    lunar_images={
      0: "new-moon.png", 
      1: "waxing-cresent.png", 
      2: "first-quarter.png", 
      3: "waxing-gibbous.png", 
      4: "full-moon.png", 
      5: "waning-gibbous.png", 
      6: "last-quarter.png", 
      7: "waning-cresent.png"
    }
    
    return lunar_images[int(current_phase)]
# ====================================================================
# Main
# ====================================================================
try:
   display_image = '/Users/mohawke/Geektool/moon.png' 
   moon_images_path = '/Users/mohawke/Geektool/Symbols/' 
   
   current = get_moon_phase(moon_images_path)
   file_pieces = current.split('.')[0].split('-')
   phase_title = file_pieces[0].capitalize()+' '+file_pieces[-1].capitalize() 
   
   print phase_title # display to geektool textual moon phase.
   # copy current phase to a generic image displayed by Geektool.
   full_image_path = os.path.join(moon_images_path,current)

   # copy current phase image to display image.
   shutil.copyfile(full_image_path,display_image)
   
except:
    print "Unable to get moon phase"