//  main.m
//  superduper
//
//  Created by Charles Nichols on 3/24/11.
//  Copyright 2011 None. All rights reserved;
// nah, not really...
 
// Standard library
#include <stdint.h>
#include <stdio.h>
 
#import <Foundation/Foundation.h>
#import <CommonCrypto/CommonDigest.h>
 
// In bytes
#define FileHashDefaultChunkSizeForReadingData 4096
 
/*
 Function FileMD5HashCreateWithPath to compute MD5 hash 
 written by Joel Lopes Da Silva.
 
 Its really simple to adapt this function to other algorithms. 
 Say you want to adapt it to get the SHA1 hash instead. 
 Heres what you need to do:
 
 replace CC_MD5_CTX with CC_SHA1_CTX;
 replace CC_MD5_Init with CC_SHA1_Init;
 replace CC_MD5_Update with CC_SHA1_Update;
 replace CC_MD5_Final with CC_SHA1_Final;
 replace CC_MD5_DIGEST_LENGTH with CC_SHA1_DIGEST_LENGTH;
 */
 
CFStringRef FileMD5HashCreateWithPath(CFStringRef filePath,
                                      size_t chunkSizeForReadingData) {
    
    // Declare needed variables
    CFStringRef result = NULL;
    CFReadStreamRef readStream = NULL;
    
    // Get the file URL
    CFURLRef fileURL =
    CFURLCreateWithFileSystemPath(kCFAllocatorDefault,
                                  (CFStringRef)filePath,
                                  kCFURLPOSIXPathStyle,
                                  (Boolean)false);
    if (!fileURL) goto done;
    
    // Create and open the read stream
    readStream = CFReadStreamCreateWithFile(kCFAllocatorDefault,
                                            (CFURLRef)fileURL);
    if (!readStream) goto done;
    bool didSucceed = (bool)CFReadStreamOpen(readStream);
    if (!didSucceed) goto done;
    
    // Initialize the hash object
    CC_MD5_CTX hashObject;
    CC_MD5_Init(&hashObject);
    
    // Make sure chunkSizeForReadingData is valid
    if (!chunkSizeForReadingData) {
        chunkSizeForReadingData = FileHashDefaultChunkSizeForReadingData;
    }
    
    // Feed the data to the hash object
    bool hasMoreData = true;
    while (hasMoreData) {
        uint8_t buffer[chunkSizeForReadingData];
        CFIndex readBytesCount = CFReadStreamRead(readStream,
                                                  (UInt8 *)buffer,
                                                  (CFIndex)sizeof(buffer));
        if (readBytesCount == -1) break;
        if (readBytesCount == 0) {
            hasMoreData = false;
            continue;
        }
        CC_MD5_Update(&hashObject,
                      (const void *)buffer,
                      (CC_LONG)readBytesCount);
    }
    
    // Check if the read operation succeeded
    didSucceed = !hasMoreData;
    
    // Compute the hash digest
    unsigned char digest[CC_MD5_DIGEST_LENGTH];
    CC_MD5_Final(digest, &hashObject);
    
    // Abort if the read operation failed
    if (!didSucceed) goto done;
    
    // Compute the string result
    char hash[2 * sizeof(digest) + 1];
    size_t i = 0;
    for (i = 0; i < sizeof(digest); ++i) {
        snprintf(hash + (2 * i), 3, "%02x", (int)(digest[i]));
    }
    result = CFStringCreateWithCString(kCFAllocatorDefault,
                                       (const char *)hash,
                                       kCFStringEncodingUTF8);
    
done:
    
    if (readStream) {
        CFReadStreamClose(readStream);
        CFRelease(readStream);
    }
    if (fileURL) {
        CFRelease(fileURL);
    }
    return result;
}
 
 
int main (int argc, const char * argv[])
{
 
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
    
 
    //NSString *path = NSHomeDirectory();
    if (argv[1] && argv[2]){
        NSString *path = [[NSString alloc] initWithUTF8String: argv[1]];
        NSString *ext = [[NSString alloc] initWithUTF8String: argv[2]];
        
        // Get all the files in our path.
        NSDirectoryEnumerator *fm = [[NSFileManager defaultManager] 
                                                     enumeratorAtPath:path];
        
        NSString *newPath;
        NSString *file;
        
        NSMutableDictionary *_matchesDictionary = [[NSMutableDictionary alloc] init];
        int count = 0;
        while ((file = [fm nextObject]))
        {
            fprintf(stderr, "searching %u\r", count++);
            
            if ([[file pathExtension] compare: ext options:NSCaseInsensitiveSearch] == NSOrderedSame)
                {
                    //NSString *filelower = [file lowercaseString];
                    newPath = [path stringByAppendingPathComponent: file];
                    CFStringRef md5hash = FileMD5HashCreateWithPath((CFStringRef)newPath,
                                                    FileHashDefaultChunkSizeForReadingData);
                    if (md5hash!=nil){
                        
                        NSString *hashKey = [NSString stringWithFormat:@"%@", md5hash];
                        
                        // check if key is already in dict.
                        if ([_matchesDictionary objectForKey: hashKey]) 
                        {
                            // pull existing array from dict and add new entry to array 
                            // for said key.
                            NSMutableArray *keyArray = [_matchesDictionary objectForKey: 
                                                                       hashKey];
                            [keyArray addObject: newPath];
         
                            // put the array back into the dict for said key.
                            [_matchesDictionary setObject: keyArray forKey: hashKey];
                            
                        } else {
                            
                            // create new array, assign empty array to said key in dict.
                            NSMutableArray *keyArray = [NSMutableArray array];
                            [keyArray addObject: newPath];
                            [_matchesDictionary setObject: keyArray forKey: hashKey];
                        
                        } 
                    }
                }
        }

        // we have gathered all paths and calculated hash for each file, 
        // any hash that matches would be a dupe file.
        NSEnumerator *keyEnum = [_matchesDictionary keyEnumerator];
        id key;
        int sz = 0;
        while ((key = [keyEnum nextObject]))
        {
            id value = [_matchesDictionary objectForKey:key];
            if ([value count] > 1){
                NSString * dupe_files = [[value valueForKey:@"description"] componentsJoinedByString:@"\n"];
                fprintf(stderr, "Dupes [%s]\n%s\n\n", [key UTF8String], [dupe_files UTF8String]);
                //NSLog(@"%@ %@", value, key);
            }
        }
        
    } else {
        fprintf(stderr, "Please provide a search path and extension;\ndupe /search_path/ file_extension\n");
    }
    
    [pool drain];
    return 0;
}