#
#		Python GUI - Pixmaps - Cocoa
#

from Foundation import NSSize
from AppKit import NSImage, NSCachedImageRep, NSBitmapImageRep, \
    NSCalibratedRGBColorSpace, NSImageCacheNever, NSGraphicsContext
from Canvases import Canvas
from GPixmaps import Pixmap as GPixmap

class Pixmap(GPixmap):
    #  _ns_bitmap_image_rep  NSBitmapImageRep

    def __init__(self, width, height):
        GPixmap.__init__(self)
        #ns_size = NSSize(width, height)
        #ns_image = NSImage.alloc().initWithSize_(ns_size)
        ns_image = NSImage.alloc().init()
        ns_image.setCacheMode_(NSImageCacheNever)
        row_bytes = 4 * width
        ns_rep = NSBitmapImageRep.alloc().\
            initWithBitmapDataPlanes_pixelsWide_pixelsHigh_bitsPerSample_samplesPerPixel_hasAlpha_isPlanar_colorSpaceName_bytesPerRow_bitsPerPixel_(
            None, width, height, 8, 4, True, False, NSCalibratedRGBColorSpace, row_bytes, 32)
        ns_image.addRepresentation_(ns_rep)
        self._init_with_ns_image(ns_image, flipped = True) #False)
        self._ns_bitmap_image_rep = ns_rep
    
    def with_canvas(self, proc):
        ns_image = self._ns_image
        ns_bitmap = self._ns_bitmap_image_rep
        #  Can't call +saveGraphicsState from Python because it clashes with an
        #  instance method of the same name.
        #NSGraphicsContext.saveGraphicsState()
        old_ctx = NSGraphicsContext.currentContext()
        ctx = NSGraphicsContext.graphicsContextWithBitmapImageRep_(ns_bitmap)
        NSGraphicsContext.setCurrentContext_(ctx)
        try:
            canvas = Canvas()
            proc(canvas)
        finally:
            #NSGraphicsContext.restoreGraphicsState()
            NSGraphicsContext.setCurrentContext_(old_ctx)
