#
#		Python GUI - Standard Menus - PyObjC
#

from Menus import Menu
from MenuLists import MenuList

_appl_menu_items = [
    ("About <app>",    'about_cmd'),
    "-",
    ("Preferences...", 'preferences_cmd'),
    "-",
    ("Hide <app>/H",   'hide_app_cmd'),
    ("Hide Others",    'hide_other_apps_cmd'),
    ("Show All",       'show_all_apps_cmd'),
    "-",
    ("Quit <app>/Q",   'quit_cmd'),
]

_file_menu_items = [
    ("New/N",      'new_cmd'),
    ("Open.../O",  'open_cmd'),
    ("Close/W",    'close_cmd'),
    "-",
    ("Save/S",     'save_cmd'),
    ("Save As...", 'save_as_cmd'),
    ("Revert",     'revert_cmd'),
    "-",
    ("Page Setup...", 'page_setup_cmd'),
    ("Print.../P",    'print_cmd'),
]

_edit_menu_items = [
    ("Undo/Z",       'undo_cmd'),
    ("Redo/^Z",      'redo_cmd'),
    "-",
    ("Cut/X",        'cut_cmd'),
    ("Copy/C",       'copy_cmd'),
    ("Paste/V",      'paste_cmd'),
    ("Delete",       'clear_cmd'),
    "-",
    ("Select All/A", 'select_all_cmd'),
]

#------------------------------------------------------------------------------

def basic_menus(substitutions = {}):
    return MenuList([
        Menu("@",    _appl_menu_items, substitutions = substitutions),
        Menu("File", _file_menu_items, substitutions = substitutions),
        Menu("Edit", _edit_menu_items, substitutions = substitutions),
    ])
