#
#		Python GUI - Utilities - PyObjC
#

from inspect import getmro

def NSMultiClass(name, bases, dic):
    #  Workaround for PyObjC classes not supporting
    #  multiple inheritance properly. Note: MRO is
    #  right to left across the bases.
    main = bases[0]
    dic2 = {}
    for mix in bases[1:]:
        for cls in getmro(mix)[::-1]:
            dic2.update(cls.__dict__)
    dic2.update(dic)
    cls = type(main)(name, (main,), dic2)
    return cls
