#--------------------------------------------------------------------------
#
#		Python GUI - Cursors - Generic
#
#--------------------------------------------------------------------------

from types import StringTypes
from Properties import Properties
from Resources import lookup_resource, find_resource

class Cursor(Properties):
    """A Cursor is an image representing the mouse pointer.
    
    Constructors:
        Cursor(resource_name, hotspot)
        Cursor(image, hotspot)
    """
    
    def __init__(self, spec, hotspot = None):
        """Construct a Cursor from a resource or Image and a hotspot point.
        The hotspot defaults to the centre of the image."""
        if isinstance(spec, StringTypes):
            self._init_from_resource(spec, hotspot)
        else:
            self._init_from_image(spec, hotspot)

    def _init_from_resource(self, resource_name, hotspot):
        from Images import Image
        image = Image(file = find_resource(resource_name))
        if not hotspot:
            hotspot = self._get_hotspot_from_resource(resource_name)
        self._init_from_image(image, hotspot)

    def _init_from_image(self, image, hotspot):
        if not hotspot:
            width, height = image.size
            hotspot = (width / 2, height / 2)
        self._init_from_image_and_hotspot(image, hotspot)

    def _get_hotspot_from_resource(self, resource_name):
        path = lookup_resource(resource_name, "hot")
        if path:
            f = open(path, "rU")
            xs, ys = f.readline().split()
            return int(xs), int(ys)
        else:
            return None
