#
#		Python GUI - DrawableViews - Gtk
#

import os, traceback
from math import floor, ceil
import gtk
from gtk import gdk
from Canvases import Canvas
from Events import Event
from GDrawableContainers import DrawableContainer as GDrawableContainer

class DrawableContainer(GDrawableContainer):

    #_extent_origin = (0, 0)

    def __init__(self, _gtk_outer = None, **kwds):
        gtk_layout = gtk.Layout()
        gtk_layout.add_events(gdk.EXPOSURE_MASK)
        gtk_layout.show()
        self._gtk_connect(gtk_layout, 'expose-event',
            self._gtk_expose_event_signal)
        if _gtk_outer:
            _gtk_outer.add(gtk_layout)
        else:
            _gtk_outer = gtk_layout
        GDrawableContainer.__init__(self, _gtk_outer = _gtk_outer, _gtk_inner = gtk_layout,
            _gtk_focus = gtk_layout, _gtk_input = gtk_layout)
        self.set(**kwds)
    
    #
    #		Other methods
    #

    def with_canvas(self, proc):
        hadj, vadj = self._gtk_adjustments()
        clip = rect_sized((hadj.value, vadj.value), self.size)
        #canvas = Canvas(self._gtk_inner_widget.bin_window, self._extent_origin, clip)
        canvas = Canvas._from_gdk_drawable(self._gtk_inner_widget.bin_window)
        proc(canvas)
    
    def invalidate_rect(self, (l, t, r, b)):
        gdk_window = self._gtk_inner_widget.bin_window
        if gdk_window:
#			x0, y0 = self._extent_origin
#			gdk_rect = (int(floor(l - x0)), int(floor(t - y0)),
#				int(ceil(r - l)), int(ceil(b - t)))
            gdk_rect = (int(floor(l)), int(floor(t)),
                int(ceil(r - l)), int(ceil(b - t)))
            #print "View.invalidate_rect: gdk_rect =", gdk_rect ###
            gdk_window.invalidate_rect(gdk_rect, 0)
    
    def update(self):
        gdk_window = self._gtk_inner_widget.bin_window
        gdk_window.process_updates()

    #
    #		Internal
    #

    def _gtk_expose_event_signal(self, gtk_event):
        try:
            #print "View._gtk_expose_event_signal:", self ###
            l, t, w, h = gtk_event.area
            clip = (l, t, l + w, t + h)
            #print "...clip =", clip ###
            gtk_layout = self._gtk_inner_widget
#			canvas = Canvas(gtk_layout.bin_window, self._extent_origin, clip)
            canvas = Canvas._from_gdk_drawable(gtk_layout.bin_window)
            self.draw(canvas, clip)
        except:
            print "------------------ Exception while drawing ------------------"
            traceback.print_exc()
