#
#   Python GUI - Scrollable Views - Gtk
#

import gtk
from Scrollables import Scrollable, gtk_scrollbar_breadth
from GScrollableViews import ScrollableView as GScrollableView, \
    default_extent, default_line_scroll_amount

class ScrollableView(GScrollableView, Scrollable):

    def __init__(self, extent = default_extent,
            line_scroll_amount = default_line_scroll_amount,
            **kwds):
        gtk_scrolled_window = gtk.ScrolledWindow()
        gtk_scrolled_window.show()
        GScrollableView.__init__(self, _gtk_outer = gtk_scrolled_window,
            extent = extent, line_scroll_amount = line_scroll_amount, **kwds)
    
    #
    #   Properties
    #
    
    def get_content_width(self):
        w = self._size[0]
        if self.hscrolling:
            w -= gtk_scrollbar_breadth
        return w
    
    def get_content_height(self):
        h = self._size[1]
        if self.vscrolling:
            h -= gtk_scrollbar_breadth
        return h
    
    def get_content_size(self):
        return self.content_width, self.content_height
    
    def set_content_size(self, size):
        w, h = size
        d = gtk_scrollbar_breadth
        if self.hscrolling:
            w += d
        if self.vscrolling:
            h += d
        self.size = (w, h)

#	def get_extent(self):
#		l, t = self._extent_origin
#		w, h = self._gtk_inner_widget.get_size()
#		return (l, t, l + w, t + h)
    
    def get_extent(self):
        return self._gtk_inner_widget.get_size()
    
#	def set_extent(self, (l, t, r, b)):
#		w = r - l
#		h = b - t
#		self._extent_origin = (l, t)
#		self._gtk_inner_widget.set_size(w, h)
    
    def set_extent(self, (w, h)):
        self._gtk_inner_widget.set_size(w, h)

    def get_scroll_offset(self):
        hadj, vadj = self._gtk_adjustments()
        return int(hadj.value), int(vadj.value)

#	def set_scroll_offset(self, (x, y)):
#		x0, y0 = self._extent_origin
#		hadj, vadj = self._gtk_adjustments()
#		hadj.set_value(min(float(x - x0), hadj.upper - hadj.page_size))
#		vadj.set_value(min(float(y - y0), vadj.upper - vadj.page_size))
    
    def set_scroll_offset(self, (x, y)):
        hadj, vadj = self._gtk_adjustments()
        hadj.set_value(min(float(x), hadj.upper - hadj.page_size))
        vadj.set_value(min(float(y), vadj.upper - vadj.page_size))

#	def get_line_scroll_amount(self):
#		x0, y0 = self._extent_origin
#		hadj, vadj = self._gtk_adjustments()
#		return x0 + hadj.step_increment, y0 + vadj.step_increment
    
    def get_line_scroll_amount(self):
        hadj, vadj = self._gtk_adjustments()
        return hadj.step_increment, vadj.step_increment
    
    def set_line_scroll_amount(self, (dx, dy)):
        hadj, vadj = self._gtk_adjustments()
        hadj.step_increment = float(dx) # Amazingly, ints are not
        vadj.step_increment = float(dy) # acceptable here.
    
    #
    #		Internal
    #

    def _gtk_adjustments(self):
        gtk_widget = self._gtk_inner_widget
        hadj = gtk_widget.get_hadjustment()
        vadj = gtk_widget.get_vadjustment()
        return hadj, vadj
