#--------------------------------------------------------------------
#
#   PyGUI - Container - Win32
#
#--------------------------------------------------------------------

import win32con as wc
from win32api import HIWORD, LOWORD
from WinUtils import WinMessageReflector
from Globals import application
from Exceptions import Cancel, InternalError
from GContainers import Container as GContainer

win_command_map = {
    0: '_win_bn_clicked', # BN_CLICKED
}

class Container(GContainer, WinMessageReflector):

#	def _win_install_event_hooks(self):
#		GContainer._win_install_event_hooks(self)
#		print "Container._win_install_event_hooks: Hooking WM_HSCROLL" ###
#		#self._win.HookMessage(self._win_wm_hscroll, wc.WM_HSCROLL)

    def OnCommand(self, wParam, lParam):
        #print "Container.OnCommand: 0x%04x 0x%04x 0x%08x" % (
        #	HIWORD(wParam), LOWORD(wParam), lParam)
        try:
            code = HIWORD(wParam)
            id = LOWORD(wParam)
            if id:
                self._win_menu_command(id)
            else:
                name = win_command_map.get(code)
                if name:
                    for comp in self.contents:
                        if comp._win.GetSafeHwnd() == lParam:
                            meth = getattr(comp, name, None)
                            if meth:
                                meth()
                            break
        except Cancel:
            pass
        except:
            application().report_error()
    
    def _win_menu_command(self, id):
        raise InternalError("_win_menu_command called on non-window: %r" % self)

    def get_content_size(self):
        return self._win.GetClientRect()[2:]
    
    def set_content_size(self, size):
        w, h = size
        win = self._win
        l, t, r, b = win.CalcWindowRect((0, 0, w, h), 1)
        self.size = (r - l, b - t)

