#--------------------------------------------------------------------
#
#   PyGUI - Menu - Win32
#
#--------------------------------------------------------------------

from weakref import WeakKeyDictionary, WeakValueDictionary
import win32con as wc, win32ui as ui
from Globals import application
from GMenus import Menu as GMenu

win_command_map = {}
win_command_list = []

def win_command_to_id(name, index = None):
    if index is not None:
        key = (name, index)
    else:
        key = name
    id = win_command_map.get(key)
    if not id:
        id = len(win_command_list) + 1
        win_command_map[key] = id
        win_command_list.append(key)
        application()._win_app.HookCommandUpdate(win_command_update, id)
    return id

def win_command_update(cmd):
    win_menu = cmd.m_pMenu
    if win_menu:
        menu = win_get_menu_for_hmenu(win_menu.GetHandle())
        if menu:
            item = menu._get_flat_item(cmd.m_nIndex)
            cmd.Enable(item.enabled)
            cmd.SetCheck(bool(item.checked))

def win_id_to_command(id):
    if 0 <= id < len(win_command_list):
        return win_command_list[id - 1]

win_hmenu_to_menubar = WeakValueDictionary()

def win_get_menu_for_hmenu(hmenu):
    menubar = win_hmenu_to_menubar.get(hmenu)
    if menubar:
        return menubar.hmenu_to_menu.get(hmenu)

#--------------------------------------------------------------------

class MenuBar(object):
    #  Wrapper around a PyCMenu
    
    def __init__(self):
        self.win_menu = ui.CreateMenu()
        self.hmenu_to_menu = {}
    
    def append_menu(self, menu):
        win_menu = menu._win_create_menu()
        hmenu = win_menu.Detach()
        self.win_menu.AppendMenu(wc.MF_POPUP | wc.MF_STRING, hmenu, menu.title)
        win_hmenu_to_menubar[hmenu] = self
        self.hmenu_to_menu[hmenu] = menu
    
#--------------------------------------------------------------------

class Menu(GMenu):

    def __init__(self, *args, **kwds):
        GMenu.__init__(self, *args, **kwds)
    
    def _update_platform_menu(self):
        #  Don't need to do anything here because platform menu item
        #  states are updated by HookCommandUpdate handlers.
        pass
    
    def _win_create_menu(self):
        #  Create a fresh platform menu reflecting the current items. Need
        #  to do this because it's not possible to share submenu handles
        #  between windows.
        self._rebuild_platform_menu()
        win_menu = self._win_menu
        self._win_menu = None # So we don't accidentally try to reuse it
        return win_menu
    
    def _clear_platform_menu(self):
        self._win_menu = ui.CreatePopupMenu()

#	def _clear_platform_menu(self):
#		#print "Menu._clear_platform_menu:", self ###
#		bypos = wc.MF_BYPOSITION
#		win_menu = self._win_menu
#		n = win_menu.GetMenuItemCount()
#		for i in xrange(n-1, -1, -1):
#			win_menu.DeleteMenu(i, bypos)
    
    def _add_separator_to_platform_menu(self):
        #print "Menu._add_separator_to_platform_menu:", self ###
        self._win_menu.AppendMenu(wc.MF_SEPARATOR, 0)
    
    def _add_item_to_platform_menu(self, item, name, command_name, *args):
        #print "Menu._add_item_to_platform_menu:", self, item, name ###
        win_text = name.replace("&", "&&")
        key = item._key
        if key:
            win_text += "\tCtrl+"
            if item._shift:
                win_text += "Shift+"
            if item._option:
                win_text += "Alt+"
            win_text += key
        flags = wc.MF_STRING
        #  These are done by HookCommandUpdate handler
        #if not item.enabled:
        #	flags |= wc.MF_GRAYED
        #if item.checked:
        #	flags |= wc.MF_CHECKED
        id = win_command_to_id(command_name, *args)
        self._win_menu.AppendMenu(flags, id, win_text)
