#--------------------------------------------------------------------
#
#   PyGUI - View - Win32
#
#--------------------------------------------------------------------

import win32con as wc, win32ui as ui
from Components import win_none
from Canvases import Canvas
from GDrawableContainers import default_size, \
    DrawableContainer as GDrawableContainer

win_style = wc.WS_VISIBLE
win_default_rect = (0, 0, default_size[0], default_size[1])

class View(GDrawableContainer):
    
    def __init__(self, **kwds):
        win = ui.CreateWnd()
        win.CreateWindow(None, None, win_style, win_default_rect,
            win_none, 0)
        GDrawableContainer.__init__(self, _win = win)
        self.set(**kwds)

    def OnPaint(self):
        #print "View.OnPaint" ###
        win = self._win
        dc, ps = win.BeginPaint()
        try:
            update_rect = ps[2]
            canvas = Canvas._from_win_dc(dc)
            self.draw(canvas, update_rect)
        finally:
            win.EndPaint(ps)
