"""
::
    Author: Charles Nichols <mohawke@gmail.com>
    Date: 11/20/2010
    Site: <http://www.darkartistry.com/>
    
Requires:
    -`pyObjC`
    -`pyGUI`
    
    
Example of pyGUI which will wake up a sleeping Macintosh.
I am not responsible for angry Apples...

Your machine must be hardwired, wireless will throw an
exception!

"""
import sys
import socket
import re
import struct
from subprocess import Popen,PIPE
from GUI import Window, TextField, Label, Button, Menu, application
# ==============================================
# Utility functions for macintosh computers...
# ==============================================
def get_mac(arg=None):
    """get_mac(arg=ip) -> tuple"""
    res,err=Popen(["/usr/sbin/arp", arg], stdout=PIPE).communicate()
    return res.split()[3],err   

def WakeOnLan(macaddr):
    """WakeOnLan(macaddr) -> str"""
    print 'Initiating wake up call...'
    # Hardware address
    addr_byte = macaddr.split(':')
    hw_addr = struct.pack('BBBBBB', int(addr_byte[0], 16),
                        int(addr_byte[1], 16),
                        int(addr_byte[2], 16),
                        int(addr_byte[3], 16),
                        int(addr_byte[4], 16),
                        int(addr_byte[5], 16))

    # Build the wake-on-lan packet
    msg = '\xff' * 6 + hw_addr * 16
    # Send via udp...
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
    s.sendto(msg, ('<broadcast>', 9))
    s.close()
    return 'Success'

# ==============================================
# pyGUI
# ==============================================

class MyWindow(Window):
    def do_default_action(self):
        print "Default"
    
    def do_cancel_action(self):
        print "Cancel" 

def processUserInput(win):
    """Handle user input"""
    try:
        if win.txtVal.value:
            if '.' in win.txtVal.value:
                ma=get_mac(arg=win.txtVal.value)[0].strip()
                print ma
                res=WakeOnLan(ma)
            elif ':' in win.txtVal.value:
                res=WakeOnLan(win.txtVal.value.strip())
            win.txtVal.text='' # clear input
            win.txtVal.text=res
        else:
            win.txtVal.text = '' # clear input
            win.txtVal.text = 'Please enter an IP or MAC'
    except:
        win.txtVal.text = '' # clear input
        win.txtVal.text = "An error occurred."

def make_window():
    """Create the application and layout"""
    win = MyWindow(size = (240, 200), title = "WakeUp")
    
    win.txtVal = TextField(position = (20, 35), width = 200)
    
    lblText=Label("IP or MAC Address:",
        position = (win.left + 20, win.txtVal.top - 25))
    
    btnEnter = Button("WakeUp!",
        position = (win.left + 135, win.txtVal.bottom + 20),
        action = (processUserInput, win)) 
            
    win.add(lblText)    
    win.add(btnEnter)      
    win.add(win.txtVal)
    win.height = btnEnter.bottom + 20
    
    win.txtVal.become_target()
    win.show()
    
    return win   
         
# ==============================================
# MAIN
# ==============================================
if __name__ == "__main__":
    win = make_window()    
    application().run()