#---------------------------------------------------------------------------
#
#   PyGUI - Layout components - Generic
#
#---------------------------------------------------------------------------

from Frames import Frame

#---------------------------------------------------------------------------

class Row(Frame):

    def __init__(self, items, spacing = 10, align = 'c', equalize = '',
            expand = None, **kwds):
        Frame.__init__(self)
        if isinstance(expand, int):
            expand = items[expand]
        equalize_components(items, equalize)
        height = 0
        for item in items:
            height = max(height, item.height)
        x = 0
        gap = 0
        hanchor = 'l'
        vanchor = align
        for item in items:
            x += gap
            if align == 't':
                y = 0
            elif align == 'b':
                y = height - item.height
            else:
                y = (height - item.height) // 2
            item.position = (x, y)
            if item is expand:
                item.anchor = 'lr' + vanchor
                hanchor = 'r'
            else:
                item.anchor = hanchor + vanchor
            x += item.width
            gap = spacing
        self.size = (x, height)
        self.add(items)
        self.set(**kwds)

#---------------------------------------------------------------------------

class Column(Frame):

    def __init__(self, items, spacing = 10, align = 'l', equalize = '',
            expand = None, **kwds):
        Frame.__init__(self)
        if isinstance(expand, int):
            expand = items[expand]
        equalize_components(items, equalize)
        width = 0
        for item in items:
            width = max(width, item.width)
        y = 0
        gap = 0
        vanchor = 't'
        hanchor = align
        for item in items:
            y += gap
            if align == 'l':
                x = 0
            elif align == 'r':
                x = width - item.width
            else:
                x = (width - item.width) // 2
            item.position = (x, y)
            if item is expand:
                item.anchor = 'tb' + hanchor
                vanchor = 'b'
            else:
                item.anchor = vanchor + hanchor
            y += item.height
            gap = spacing
        self.size = (width, y)
        self.add(items)
        self.set(**kwds)

#---------------------------------------------------------------------------

class Grid(Frame):

    def __init__(self, items, row_spacing = 5, column_spacing = 10,
            align = 'l', equalize = '', expand_row = None, expand_column = None,
            **kwds):
        Frame.__init__(self)
        num_rows = len(items)
        num_cols = max([len(row) for row in items])
        col_widths = [0] * num_cols
        row_heights = [0] * num_rows
        for i, row in enumerate(items):
            for j, item in enumerate(row):
                row_heights[i] = max(row_heights[i], item.height)
                col_widths[j] = max(col_widths[j], item.width)
        tot_width = 0
        row_top = 0
        row_gap = 0
        vanchor = 't'
        for i, row in enumerate(items):
            row_height = row_heights[i]
            row_top += row_gap
            col_left = 0
            col_gap = 0
            hanchor = 'l'
            if i == expand_row:
                vanchor = 'tb'
            for j, item in enumerate(row):
                col_width = col_widths[j]
                col_left += col_gap
                if 'l' in align:
                    x = 0
                elif 'r' in align:
                    x = col_width - item.width
                else:
                    x = (col_width - item.width) // 2
                if 't' in align:
                    y = 0
                elif 'b' in align:
                    y = row_height - item.height
                else:
                    y = (row_height - item.height) // 2
                item.position = (col_left + x, row_top + y)
                if j == expand_column:
                    item.anchor = 'lr' + vanchor
                    hanchor = 'r'
                else:
                    item.anchor = hanchor + vanchor
                self.add(item)
                col_left += col_width
                col_gap = column_spacing
                tot_width = max(tot_width, col_left)
            if i == expand_row:
                vanchor = 'b'
            row_top += row_height
            row_gap = row_spacing
        tot_height = row_top
        self.size = (tot_width, tot_height)
        self.set(**kwds)

#---------------------------------------------------------------------------

def equalize_components(items, flags):
    if items:
        if 'w' in flags:
            width = max([item.width for item in items])
            for item in items:
                item.width = width
        if 'h' in flags:
            height = max([item.height for item in items])
            for item in items:
                item.height = height
