#--------------------------------------------------------------------
#
#   PyGUI - Application - Win32
#
#--------------------------------------------------------------------

import win32con as wc, win32ui as ui, win32clipboard as wcb, win32api as api
import Components, Windows, WinUtils
from GApplications import Application as GApplication

class Application(GApplication):

    def __init__(self, *args, **kwds):
        self._win_recycle_list = []
        self._win_app = ui.GetApp()
        self._win_app.AttachObject(self)
        self._win_app.SetMainFrame(WinUtils.win_none)
        GApplication.__init__(self, *args, **kwds)
    
    def set_menus(self, x):
        #print "Application.set_menus" ###
        GApplication.set_menus(self, x)
        for window in self.windows:
            window._win_menus_changed()
    
    def _event_loop(self, window):
        if window:
            window._begin_modal()
        try:
            self._win_app.Run()
        finally:
            if window:
                window._end_modal()

    def _exit_event_loop(self):
        api.PostQuitMessage(0)

    def zero_windows_allowed(self):
        return False
    
    def get_target(self):
        try:
            win = ui.GetFocus()
        except ui.error:
            win = None
        if isinstance(win, Components.Component):
            return win
        else:
            return self

    def get_target_window(self):
        win = ui.GetActiveWindow()
        if isinstance(win, Windows.Window):
            return win
    
    def OnIdle(self, x):
        trash = self._win_recycle_list
        while trash:
            trash.pop().DestroyWindow()
        return 0
    
#	def PreTranslateMessage(self, msg):
#		print "Application.PreTranslateMessage:", msg ###

    def _win_recycle(self, win):
        #  It's not safe to destroy a window inside code called from its
        #  own OnCommand handler, so we use this method to delay it until
        #  a better time.
        self._win_recycle_list.append(win)

    def query_clipboard(self):
        wcb.OpenClipboard()
        result = wcb.IsClipboardFormatAvailable(wc.CF_TEXT)
        wcb.CloseClipboard()
        return result
    
    def get_clipboard(self):
        wcb.OpenClipboard()
        result = win32clipboard.GetClipboardData()
        wcb.CloseClipboard()
        return result
    
    def set_clipboard(self, x):
        wcb.OpenClipboard()
        win32clipboard.SetClipboardData(wc.CF_TEXT, x)
        wcb.CloseClipboard()
