#--------------------------------------------------------------------
#
#   PyGUI - Win32 - Utilities
#
#--------------------------------------------------------------------

import win32con as wc, win32ui as ui

#  Dummy CWnd for use as parent of containerless components.
#  Also used as the main frame of the CWinApp.

win_none = ui.CreateFrame()
win_none.CreateWindow(None, "", 0, (0, 0, 10, 10))

class WinMessageReflector(object):

    def _win_install_event_hooks(self, win):
        win.HookMessage(self._win_wm_scroll, wc.WM_HSCROLL)
        win.HookMessage(self._win_wm_scroll, wc.WM_VSCROLL)

#
#  Disabled for now because overriding control colours
#  doesn't seem to work properly on XP.
#
#	def OnCtlColor(self, dc, comp, typ):
#		#print "WinMessageReflector.OnCtlColor" ###
#		meth = getattr(comp, '_win_on_ctlcolor', None)
#		if meth:
#			return meth(dc, typ)

    def _win_wm_scroll(self, message):
        #print "WinMessageReflector._win_wm_scroll:", self, message ###
        wParam = message[2]
        code = wParam & 0xffff
        lParam = message[3]
        wnd = ui.CreateWindowFromHandle(lParam)
        meth = getattr(wnd, '_win_wm_scroll', None)
        if meth:
            meth(code)

win_none_wrapper = WinMessageReflector()
win_none_wrapper._win = win_none
win_none_wrapper._win_install_event_hooks(win_none)
win_none.AttachObject(win_none_wrapper)

#--------------------------------------------------------------------
#
#   Debugging routines
#

win_message_names = {}

win_exclude_names = ["WM_MOUSEFIRST"]

for name, value in wc.__dict__.iteritems():
    if name.startswith("WM_") and name not in win_exclude_names:
        win_message_names[value] = name

def win_message_name(num):
    return win_message_names.get(num) or num

def dump_flags(flags):
    for name in wc.__dict__.iterkeys():
        if name.startswith("WS_") and not name.startswith("WS_EX"):
            value = wc.__dict__[name]
            if flags & value:
                print "%20s = 0x%08x" % (name, value & 0xffffffffL)
        
def win_deconstruct_style(flags):
    win_do_deconstruct_style(flags, "WS_", "WS_EX_")

def win_deconstruct_style_ex(flags):
    win_do_deconstruct_style(flags, "WS_EX_")

def win_do_deconstruct_style(flags, prefix, not_prefix = None):
    d = wc.__dict__
    for name in d.iterkeys():
        if name.startswith(prefix):
            if not not_prefix or not name.startswith(not_prefix):
                value = d[name]
                if value and flags & value == value:
                    print "%25s 0x%08x" % (name, value)
