unit weedcalc; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Menus, ComCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    btnEnter: TButton;
    btnClear: TButton;
    GroupBox1: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    mnuFile: TMenuItem;
    txtProHalf: TEdit;
    txtProQtr: TEdit;
    txtProEth: TEdit;
    txtProDime: TEdit;
    txtProNkl: TEdit;
    txtInvestment: TEdit;
    txtBaseHalf: TEdit;
    txtBaseQtr: TEdit;
    txtBaseEth: TEdit;
    txtBaseDime: TEdit;
    txtBaseNkl: TEdit;
    txtBaseWhole: TEdit;
    txtTotalGrams: TEdit;
    txtHalf: TEdit;
    txtQtr: TEdit;
    txtEth: TEdit;
    txtDime: TEdit;
    txtNkl: TEdit;
    Half: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    radOunces: TRadioButton;
    radPounds: TRadioButton;
    radKilos: TRadioButton;
    RadioGroup1: TRadioGroup;
    txtAmount: TEdit;
    txtPrice: TEdit;
    Label1: TLabel;
    Label2: TLabel;

    procedure btnClearClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure mnuHelpClick(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end; 

const
  constPoundsInKilo  = 2.20402;
  constOuncesInPound = 16.0;
  constGramsInPound  = 453.592;
  constGramsInOunces = 28.3495231;
  CR = #13;
  LF = #10;
  Newline = CR+LF;
var
  Form1: TForm1; 
  strWeight, strCost, strWhole, strHalf, strQtr, strEth, strDime, strNkl: String;
  basePrice,totalCost: Extended;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
     halt;
end;

procedure TForm1.mnuHelpClick(Sender: TObject);
begin
     ShowMessage('WeedCalc 0.1b'+Newline+'A little Pascal app by Mohawke <www.darkartistry.com>'+Newline+'Created July 2012 for the hell of it.');
end;

procedure TForm1.btnEnterClick(Sender: TObject);
begin
     if (radOunces.Checked = True) and (StrToFloat(txtAmount.Text) < constOuncesInPound) then
        begin
             basePrice:= StrToFloat(txtPrice.Text) / constGramsInOunces;
             totalCost:= basePrice * (constGramsInOunces * StrToFloat(txtAmount.Text));

             strWhole:= '$'+FloatToStr(totalCost);
             txtInvestment.Text:= strWhole;
             txtTotalGrams.Text:= FloatToStr(round(constGramsInOunces * StrToFloat(txtAmount.Text)))+'g';

             Label5.Caption:= 'Dime:';
             Label6.Caption:= 'Nickel:';

             txtHalf.Text:= FloatToStr(Round(constGramsInOunces / 2))+'g';
             txtQtr.Text:= FloatToStr(Round(constGramsInOunces / 4))+'g';
             txtEth.Text:= leftstr(FloatToStr(constGramsInOunces / 8),3)+'g';
             txtDime.Text:= FloatToStr(Round(constGramsInOunces / 16))+'g';
             txtNkl.Text:= FloatToStr(Round((constGramsInOunces / 16) / 2))+'g';

             txtBaseWhole.Text:= '$'+txtPrice.Text;
             txtBaseHalf.Text:= '$'+FloatToStr(Round((constGramsInOunces / 2) * basePrice))+'.00';
             txtBaseQtr.Text:= '$'+FloatToStr(Round((constGramsInOunces / 4) * basePrice))+'.00';
             txtBaseEth.Text:= '$'+FloatToStr((Round((constGramsInOunces / 8) * basePrice)))+'.00';
             txtBaseDime.Text:= '$'+FloatToStr(Round((constGramsInOunces / 16) * basePrice))+'.00';
             txtBaseNkl.Text:= '$'+FloatToStr(Round((constGramsInOunces / 16) / 2 * basePrice))+'.00';

             txtProHalf.Text:= '$'+FloatToStr(Round((constGramsInOunces / 2) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
             txtProQtr.Text:= '$'+FloatToStr(Round((constGramsInOunces / 4) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
             txtProEth.Text:= '$'+FloatToStr((Round((constGramsInOunces / 8) * basePrice)) * StrToFloat(txtAmount.Text))+'.00';
             txtProDime.Text:= '$'+FloatToStr(Round((constGramsInOunces / 16) * basePrice) * StrToFloat(txtAmount.Text))+'.00';
             txtProNkl.Text:= '$'+FloatToStr(Round((constGramsInOunces / 16) / 2 * basePrice) * StrToFloat(txtAmount.Text))+'.00';
        end;

     if (radOunces.Checked = True) and (StrToFloat(txtAmount.Text) > constOuncesInPound) then
         begin
              ShowMessage('Dude, I think you want pounds.');
         end;

     if (radPounds.Checked = True) and (StrToFloat(txtAmount.Text) < constPoundsInKilo) then
         begin
              basePrice:= StrToFloat(txtPrice.Text) / constGramsInPound;
              totalCost:= basePrice * (constGramsInPound * StrToFloat(txtAmount.Text));

              strWhole:= '$'+FloatToStr(totalCost);
              txtInvestment.Text:= strWhole;
              txtTotalGrams.Text:= FloatToStr(round(constGramsInPound * StrToFloat(txtAmount.Text)))+'g';

              txtHalf.Text:= FloatToStr(Round(constGramsInPound / 2))+'g';
              txtQtr.Text:= FloatToStr(Round(constGramsInPound / 4))+'g';
              txtEth.Text:= leftstr(FloatToStr(constGramsInPound / 8),3)+'g';
              txtDime.Text:= FloatToStr(Round(constGramsInPound / 16))+'g';
              txtNkl.Text:= FloatToStr(Round((constGramsInPound / 16) / 2))+'g';

              Label5.Caption:= 'Ounce:';
              Label6.Caption:= 'Half Oz:';

              txtBaseWhole.Text:= '$'+txtPrice.Text;
              txtBaseHalf.Text:= '$'+FloatToStr(Round((constGramsInPound / 2) * basePrice))+'.00';
              txtBaseQtr.Text:= '$'+FloatToStr(Round((constGramsInPound / 4) * basePrice))+'.00';
              txtBaseEth.Text:= '$'+FloatToStr((Round((constGramsInPound / 8) * basePrice)))+'.00';
              txtBaseDime.Text:= '$'+FloatToStr(Round((constGramsInPound / 16) * basePrice))+'.00';
              txtBaseNkl.Text:= '$'+FloatToStr(Round((constGramsInPound / 16) / 2 * basePrice))+'.00';

              txtProHalf.Text:= '$'+FloatToStr(Round((constGramsInPound / 2) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
              txtProQtr.Text:= '$'+FloatToStr(Round((constGramsInPound / 4) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
              txtProEth.Text:= '$'+FloatToStr((Round((constGramsInPound / 8) * basePrice)) * StrToFloat(txtAmount.Text))+'.00';
              txtProDime.Text:= '$'+FloatToStr(Round((constGramsInPound / 16) * basePrice) * StrToFloat(txtAmount.Text))+'.00';
              txtProNkl.Text:= '$'+FloatToStr(Round((constGramsInPound / 16) / 2 * basePrice) * StrToFloat(txtAmount.Text))+'.00';
         end;
     if radKilos.Checked = True then
         begin
              basePrice:= StrToFloat(txtPrice.Text) / constPoundsInKilo;
              totalCost:= basePrice * (constPoundsInKilo * StrToFloat(txtAmount.Text));

              strWhole:= '$'+FloatToStr(totalCost);
              txtInvestment.Text:= strWhole;
              txtTotalGrams.Text:= leftstr(FloatToStr(constPoundsInKilo * StrToFloat(txtAmount.Text)),3)+'lbs';

              txtHalf.Text:= leftstr(FloatToStr(constPoundsInKilo / 2),3)+'lbs';
              txtQtr.Text:= leftstr(FloatToStr(constPoundsInKilo / 4),3)+'lbs';
              txtEth.Text:= leftstr(FloatToStr(constPoundsInKilo / 8),3)+'lbs';

              txtDime.Text:= '0';
              txtDime.Enabled:=False;
              txtNkl.Text:= '0';
              txtNkl.Enabled:=False;

              txtBaseWhole.Text:= '$'+txtPrice.Text;
              txtBaseHalf.Text:= '$'+FloatToStr(Round((constPoundsInKilo / 2) * basePrice))+'.00';
              txtBaseQtr.Text:= '$'+FloatToStr(Round((constPoundsInKilo / 4) * basePrice))+'.00';
              txtBaseEth.Text:= '$'+FloatToStr((Round((constPoundsInKilo / 8) * basePrice)))+'.00';
              txtBaseDime.Text:= '$0.0';
              txtBaseNkl.Text:= '$0.0';
              txtBaseDime.Enabled:=False;
              txtBaseNkl.Enabled:=False;

              txtProHalf.Text:= '$'+FloatToStr(Round((constPoundsInKilo / 2) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
              txtProQtr.Text:= '$'+FloatToStr(Round((constPoundsInKilo / 4) * basePrice)  * StrToFloat(txtAmount.Text))+'.00';
              txtProEth.Text:= '$'+FloatToStr((Round((constPoundsInKilo / 8) * basePrice)) * StrToFloat(txtAmount.Text))+'.00';
              txtProDime.Text:= '$0.0';
              txtProNkl.Text:= '$0.0';
              txtProDime.Enabled:=False;
              txtProNkl.Enabled:=False;

              if StrToFloat(txtAmount.Text) > 2 then
                  begin
                       ShowMessage('Shit dude, with that kind of money you can hire an accountant!')
                  end;

         end;
end;

procedure TForm1.btnClearClick(Sender: TObject);
begin
     radOunces.Checked:= True;

     txtBaseDime.Enabled:=True;
     txtBaseNkl.Enabled:=True;
     txtProDime.Enabled:=True;
     txtProNkl.Enabled:=True;
     txtDime.Enabled:=True;
     txtNkl.Enabled:=True;

     txtAmount.Text:= '1';
     txtPrice.Text:= '0';

     txtInvestment.Text:= '0';
     txtTotalGrams.Text:= '0';

     txtHalf.Text:= '0';
     txtQtr.Text:= '0';
     txtEth.Text:= '0';
     txtDime.Text:= '0';
     txtNkl.Text:= '0';

     txtBaseWhole.Text:= '$0.0';
     txtBaseHalf.Text:= '$0.0';
     txtBaseQtr.Text:= '$0.0';
     txtBaseEth.Text:= '$0.0';
     txtBaseDime.Text:= '$0.0';
     txtBaseNkl.Text:= '$0.0';

     txtProHalf.Text:= '$0.0';
     txtProQtr.Text:= '$0.0';
     txtProEth.Text:= '$0.0';
     txtProDime.Text:= '$0.0';
     txtProNkl.Text:= '$0.0';
end;

end.

